# Szyfr Cezara:
# https://www.nostarch.com/crackingcodes (na licencji BSD).

import pyperclip

# Ciąg tekstowy przeznaczony do szyfrowania i deszyfrowania:
message = 'To jest moja tajna wiadomość.'

# Klucz szyfrowania i deszyfrowania:
key = 13

# Określenie trybu pracy - szyfrowanie (encrypt) lub deszyfrowanie (decrypt):
mode = 'encrypt'  # Przypisanie wartości 'encrypt' lub 'decrypt'.

# Znaki, które można zaszyfrować:
SYMBOLS = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890 !?.'

# Zmienna przechowująca zaszyfrowaną lub odszyfrowaną postać wiadomości:
translated = ''

for symbol in message:
    # Tylko symbole zdefiniowane w ciągu tekstowym SYMBOLS mogą być szyfrowane i deszyfrowane.
    if symbol in SYMBOLS:
        symbolIndex = SYMBOLS.find(symbol)

        # Przeprowadzenie szyfrowania i deszyfrowania:
        if mode == 'encrypt':
            translatedIndex = symbolIndex + key
        elif mode == 'decrypt':
            translatedIndex = symbolIndex - key

        # Obsługa zawinięcia, jeżeli zachodzi potrzeba:
        if translatedIndex >= len(SYMBOLS):
            translatedIndex = translatedIndex - len(SYMBOLS)
        elif translatedIndex < 0:
            translatedIndex = translatedIndex + len(SYMBOLS)

        translated = translated + SYMBOLS[translatedIndex]
    else:
        # Dołączenie znaku bez jego wcześniejszego szyfrowania i deszyfrowania.
        translated = translated + symbol

# Wyświetlenie skonwertowanego ciągu tekstowego:
print(translated)
pyperclip.copy(translated)
